-- change directory to program location
parse source  . . pgm
call directory filespec('L', pgm) 

-- define the source file
file="15-PDFa.pdf"

-- use the parser to validate the document and save the result
pclass = "org.apache.pdfbox.preflight.parser.PreflightParser"
parser=.bsf~new(pclass,file)
doc=parser~parse
if doc~validate~isValid=1 
then content=file " is a valid PDF/A-1b document"
else content=file " is not a valid PDF/A-1b document"

-- create a new document and add a blank page
doc=.bsf~new("org.apache.pdfbox.pdmodel.PDDocument")
page=.bsf~new("org.apache.pdfbox.pdmodel.PDPage")
doc~addPage(page)

-- create a content stream
contclass = "org.apache.pdfbox.pdmodel.PDPageContentStream"
cont=.bsf~new(contclass,doc,page)

-- define font type
fontclass = "org.apache.pdfbox.pdmodel.font.Standard14Fonts"
fname = BSF.loadClass(fontclass)~FontName~HELVETICA_BOLD
font=.bsf~new("org.apache.pdfbox.pdmodel.font.PDType1Font",fname)

-- use the content stream to insert validation result
cont~beginText
cont~setFont(font, 22)
cont~setLeading(25f)
cont~newLineAtOffset(100, 700)
cont~showText(content)
cont~endText
cont~close

-- save and close the document file
doc~save("16-validation result.pdf")
doc~close

-- get java support
::requires "BSF.CLS"